#Author: Dr.C. Sweetlin Hemalatha, Associate Professor, School of Computing Science & Engineering, VIT Chennai
#Ex9-Statistical Analysis of quantitative data
#R version 3.3.3
#RStudio version 1.2.1335
rm(list=ls())

library(MASS)
newsurvey <- na.omit(survey)

#1.  Find the range of students' age participated in the survey.
age_rg <- newsurvey$Age
print(range(age_rg))

#2.  Break the age range into non-overlapping sub-intervals by defining a sequence of equal distance break points of 10 by rounding the range to nearest integer.
breaks <- seq(15,75,by=10)
age_rg_brk <- cut(age_rg,breaks,right=TRUE)

#3.  Find the distribution of  the age range according to the sub-intervals with cut with its right boundary opened.
age_freq <- table(age_rg_brk)
print(cbind(age_freq))

#4.  Which age range of students has mostly participated in the survey.
print(which.max(age_freq))

#5. Find the frequency distribution of Wr.Hnd span and display it in column format.
write_hand_span<- newsurvey$Wr.Hnd 
range(write_hand_span)
breakspan <- seq(10,25,by=5)
wr_hnd_dist <- table(cut(write_hand_span,breakspan,right=TRUE))
print(cbind(wr_hnd_dist))

#6.  Find the relative frequency of Wr.Hnd and display it by correcting to 3 decimal places.
options(digits=2)
print(wr_hnd_dist/nrow(newsurvey))
